
                           D  Y  N  A  M  O
                           ----------------

          
                           INHALTSBERSICHT


    0.      Einfhrung

    1.      Installation 

    2.      Bedienung des Programms 

    3.      Menpunkte 
    3.1       Sourcetext
    3.2       Makros
    3.3       Editor starten
    3.4       Pfadname festlegen
    3.5       Plotten
    3.6       Autoskal
    3.7       DPlott
    3.8       Printen & Drucken
    3.9       Neustart
    3.10      Bibliothek
    3.11      Druckerplotten
    3.12      Variablen
    3.13      Tabellen
    3.14      Werte ndern

    4.      Aufbau der Dynamoprogramme
    
    5.      Kennzeichnung der Zeilen
    5.1       A Auxiliaries
    5.2       C Konstanten
    5.3       L Level        
    5.4       N Initialisierung
    5.5       R Raten
    5.6       S Supplementary
    5.7       T Tabellendefinition
    5.8       PRINT
    5.9       PLOT
    5.10      NOTE
    5.11      SPEC
    5.12      M
    
    6.      Sprachkonventionen fr Level und Rates
    6.1       Wie werden die einzelnen Gleichungen berechnet
    
    7.      Syntax und eingebaute Funktionen
    
    8.      Makrodefinition

    9.      Makrobibliothek

    10.     Literatur




    0.      Einfhrung
            ----------
    Dies ist eine kurze Einfhrung in Dynamo und eine Erklrung
    ber den bisherigen Implementierungsstand.

    Was ist DYNAMO ?
    Dynamo ist eine Programmiersprache, mit der Sie mathematische
    Modelle simulieren knnen!

    Durch Simulationen sollen Aussagen ber die Wirklichkeit gewonnen
    werden,die auf andere Art entweder gar nicht oder nur sehr schwer
    zu erhalten wren.
    Modelle werden in allen Bereichen der Wissenschaft benutzt.
    Auf dieser Diskette befinden sich ein paar einfache Beispiele.
    Aus der Biologie ein Frezyklus von Fchsen und Hasen (sehr vereinfacht).    
    
    Dynamo lt sich brigens auch hervorragend als Funktionsplotter
    gebrauchen.
    

    1.      Installation :
            --------------
    Es mu mindestens 1MB Speicher zur Verfgung stehen.

    Sie knnen von Dynamo aus direkt einen Texteditor aufrufen.
    Damit dies mglich ist mu der komplette Pfadname in der
    Datei EDITOR_P.FAD angegeben sein.
    Mit der Funktion 'Pfadname festlegen' kann der Pfadname 
    festgelegt werden.


    2.      Bedienung des Programms :
            -------------------------
    Als erstes mu ein Dynamoprogramm geladen werden.Dynamoprogramme
    haben die Endung .DYN .Whlen Sie den Mentitel 'Datei laden' an
    und whlen Sie ein Programm mit Hilfe der Fileselektorbox aus.
    Das Programm wird nun geladen und bersetzt.
    Nun kann es richtig losgehen !
    Unter dem Mentitel 'Berechnen' stehen verschiedene Funktionen
    fr eine Ausgabe bereit.
    

    3.      Menpunkte :
            ------------
    3.1  Sourcetext
    Um zu sehen was geladen wurde, gibt es unter dem Mentitel 
    Optionen den Eintrag 'Sourcetext' ,der den Text in ein
    Fenster ausgibt.

    3.2  Makros
    Wenn die Bibliothek aktiviert wurde kann hiermit der
    zugehrige Sourcetext ausgegeben werden.

    3.3  Editor starten
    Editor starten ermglicht es direkt einen Texteditor aufzurufen.
    Sie mssen somit Dynamo nicht verlassen wenn der Sourcetext
    gendert werden soll.Der Editor wird mit dem Namen der aktuellen
    Datei aufgerufen.Nach der Rckkehr zu Dynamo wird der Sourcetext
    automatisch neu geladen!
    Auf dieser Diskette befindet sich kein Editor,Sie mssen also
    Ihren eigenen hinzukopieren.
    Damit Dynamo Ihren Editor finden kann,mssen Sie die Datei
    EDITOR_P.FAD ndern und den Pfadnamen Ihres Editors eingeben !
    Der Pfadname kann unter dem Menpunkt 'Pfadname festlegen'
    festgelegt werden. Benutzen Sie aber nur einen Editor der
    einen ASCII Code erzeugt !


    3.4  Pfadname festlegen
    Hier kann der Pfadname fr den Texteditor festgelegt werden.
    Der Pfad wird in der Datei EDITORP.FAD abgelegt.
    
    3.5  Plotten
    Plotten gibt die berechneten Werte in Form von Kurven aus.
    Im Dynamoprogramm mu sich eine Zeile vom Typ PLOT befinden.

     Bsp.:  PLOT  A=I(10,20),B=J

    In diesem Beispiel sind A und B definierte Variablen aus
    dem Dynamoprogramm.Die Buchstaben hinter dem Gleichheitszeichen
    sind der Syntax nach erforderlich aber hier ohne Bedeutung.
    Der Bereich in den Klammern (hier 10-20) gibt den Plottbereich
    der Variablen an.Wird kein Bereich angegeben,so versucht Dynamo
    einen geeigneten Bereich selbst zu finden.
    Weiteres hierzu unter dem Menpunkt 'Autoskal'.
    Wird nun Plotten gestartet, so ffnen sich zwei Fenster.
    Im oberen Fenster werden die Kurven ausgegeben.
    Im unteren Fenster werden die Variablennamen,eine Nummer,
    der Plottbereich und der Wert der Variablen ausgegeben.
    Durch die Nummer ist eine Zuordnung zu den Kurven mglich.
    Abbrechen des Plottvorgangs ist durch Drcken der linken
    Maustaste mglich.
    Mit der rechten Maustaste kann der Plotvorgang angehalten
    werden und es werden die aktuellen Werte der Variablen im
    unterem Fenster ausgegeben.

    3.6  Autoskal
    Mit Autoskal kann eine automatische Skalierung zugelassen oder
    unterbunden werden.Normalerweise ist Autoskal eingeschaltet.
    Wenn beim Plotten die Werte den angegebenen Bereich berschreiten
    wird der Plottbereich automatisch vergrert.

    3.7  DPlott
    Beim 'normalen' Plotten ist auf der x-Achse die Zeit eingetragen.
    Bei DPlott kann die x-Achse einer eigenen Variablen zugewiesen
    werden.Dies ist in Dynamo eigentlich nicht vorgesehen, aber
    manchmal sehr informativ.Um DPlott benutzen zu knnen ,men
    in der PLOT-Zeile mindestens zwei Variablen angegeben werden.
    Die erste Variable bernimmt die x-Achse,die Zweite die y-Achse.
    Weitere Plott-Variablen werden in diesem Modus ignoriert.

    3.8  Printen & Drucken
    Mit Printen und Drucken ist eine numerische Ausgabe von Variablen
    mglich.Drucken unterscheidet sich durch Printen nur dadurch,
    da die Werte zustzlich zum Bildschirm auch auf dem Drucker
    ausgegeben werden.
    Es wird ein Fenster erffnet in dem die Namen der Variablen
    und die berechneten Werte ausgeben werden.
    Wie bei Plotten ist natrlich eine entsprechende Zeile im
    Sourcetext notwendig.

      Bsp.:   PRINT  A,B

    A und B sind wieder definierte Variablen.Ein Bereich wie bei
    Plotten ist nicht notwendig.
    Ein Abbruch der Funktion ist wieder durch Drcken der linken
    Maustaste mglich.
    Nach einer Seitenausgabe hlt die Berechnung an und Dynamo
    wartet auf einen Tastendruck der rechten Maustaste.
    Es werden maximal 6 Variablen gleichzeitig ausgegeben.

    3.9  Neustart
    Wenn der Plottvorgang oder der Druckvorgang nach einer
    Unterbrechung neu gestartet wurde,so rechnet Dynamo mit den
    alten Werten weiter.Soll von vorn begonnen werden so mu
    mit Neustart der Anfangszustand wieder hergestellt werden.
    Es wird das komplette Programm neu bersetzt.

    3.10  Bibliothek
    In Dynamo ist eine Makrodefinition erlaubt.Damit nun Makros
    nicht in jedem Listing definiert werden mssen gibt es diese
    Bibliothek.Sie mu sich natrlich beim Aktivieren auf der
    Diskette befinden.Danach knnen die Makros wie normale
    Funktionen benutzt werden.
    Mit 'Makros' unter dem Deskeintrag 'Optionen' wird der
    zugehrige Sourcecode ausgegeben.
   
    3.11 Druckerplotten
    Ist die Option Druckerplotten eingeschaltet, so werden die 
    Kurven beim Menpunkt Plotten automatisch auch auf dem
    Drucker ausgegeben.
    Die Ausgabe funktioniert bisher nur mit dem NEC P6 Drucker.

    3.12 Variablen
    Es werden alle definierten Konstanten und Variablen des aktuellen
    Listings ausgegeben.Nach jeder Seite wird auf einen Mausklick
    gewartet.Wurden alle Variablen ausgegeben,so kann die Funktion
    durch Drcken der linken Maustaste beendet werden.
    Beim Druck auf die rechte Maustaste wird ein Zyklus berechnet
    und die Variablen neu ausgegeben.

    3.13 Tabellen
    Hierbei werden benutzte Tabellen in grafischer Form ausgegeben.
    rechte Maustaste : nchste Tabelle falls vorhanden
    linke  Maustaste : Abbruch

    3.14 Werte ndern
    Es wird eine Box ausgeben mit der die aktuellen Werte fr alle
    definierten Variablen,Konstanten und Tabelleneintrge gendert
    werden knnen.
    Man kann also einen Plotvorgang unterbrechen,Werte ndern und
    den Plotvorgang mit genderten Parametern fortsetzen.
    Die Box wird mit der rechten Maustaste geschlossen.
    Wird eine falsche Eingabe gemacht, so wird der alte Wert 
    beibehalten.


    4.      Aufbau der Dynamoprogramme :
            ----------------------------
    Dynamoprogramme sind normale ASCII-Files.
    Benutzen Sie einen Texteditor der auch ASCII-Files erzeugt!

    Dynamoprogramme werden zeilenweise in eine Datei geschrieben.
    Jede Zeile beginnt mit einer Kennzeichnung.
    Zwischen der Anweisung und der Kennzeichnung drfen beliebig
    viele Leerzeichen stehen.
    Innerhalb der Anweisung drfen KEINE Leerzeichen stehen !
    Steht hinter der Anweisung ein Leerzeichen gilt der restliche
    Zeileninhalt als Kommentar. 
    Ausnahme : NOTE  Hier ist die ganze Zeile Kommentar !

      Bsp.:   
      L       A.K=A.J+DT*B.K       Hinweis
      ^^     ^^            ^^
      ||_____||____________||
      |   |          |      Start des Kommentars
      |   |          Anweisung
      |   Leerzeichen
      Kennzeichnung

    Es kann also jede Zeile direkt kommentiert werden ohne die
    NOTE Zeile zu benutzen.
    Mit Kommentar sollte man nicht sparsam sein, da Dynamoprogramme
    schwer lesbar sind.


    5.      Kennzeichnung der Zeilen :
            --------------------------
    Dynamo ist im Aufbau eine sehr einfache  Sprache.
    Jede Zeile mu mit einer Kennzeichnung beginnen ,die die
    Art der Anweisung festlegt.Dies sind :
    A,C,L,N,R,S,PRINT,PLOT,NOTE,SPEC,MACRO,MEND

     A     :  Auxiliaries
     C     :  Konstantendefinition
     L     :  Level-Gleichungen
     N     :  Initialisierungsgleichungen
     R     :  Raten-Geleichungen
     S     :  Supplementary-Gleichung
     T     :  Tabellendefinition
     PRINT :  Definieren von Printvariablen
     PLOT  :  Definieren von Plottvariablen
     NOTE  :  Kommentarzeilen
     SPEC  :  Laufanweisung
     MACRO :  Makrodefinition Anfang
     MEND  :  Makroende
     

    5.1    A Auxiliaries
           -------------
    In Auxiliaries Gleichungen werden Level-Gren und Auxiliaries
    in Beziehung gesetzt.Es knnen gemischte Ausdrcke von Level
    und Rates-Gren auftreten.     
           
        Bsp.:  A   Hasenprofuchs.K=Hasen.K/Fuechse.K
     
    

    5.2    C Konstanten
           ------------
    Konstante Zahlen knnen mit einem Namen versehen werden.
    Eine Vernderung ist nicht erlaubt.
    Mehrere Konstantendefinitionen knnen in einer Zeile
    zusammengefat werden.

        Bsp.:  C   HGK=1,TREFF=0.1,FSK=6

    DT,PLTPER,PRTPER,LENGTH knnen als Konstanten definiert werden.


    5.3    L Level
           -------
    Diese Gleichungen beziehen eine Gre zum augenblicklichen
    Zeitpunkt auf ihren alten Wert  und auf die Vernderungsrate 
    in der Zwischenzeit.
    
    Bsp.:  L   HASEN.K=HASEN.J+DT*(HGRATE.JK-HSRATE.JK)
    
    Levelgleichungen werden auch Integrationsgleichungen genannt,
    da die ganze Gre aus der Summation ihrer Vernderungsgre
    berechnet wird.
    
         
    5.4    N Initialisierung
           -----------------
    Initialisierungsgleichungen dienen dazu Variablen Anfangswerte
    zuzuweisen.Werden keine N-Gleichungen fr zeitabhngige Gren
    angegeben,versucht Dynamo geeignete Werte aus den benutzten
    Gleichungen zu berechnen.
    Konnte eine Variable trotzdem nicht Initialisiert werden,so
    wird eine entsprechende Fehlermeldung ausgegeben.Es mu
    dann eine weitere N-Gleichung eingefgt werden.

    
    5.5    R Raten
           -------
    Ratengleichungen sind Vernderungsraten.Die Endung bei
    Raten ist .KL da die Rate fr das nchste Zeitintervall berechnet
    wird.
        Bsp.:  R    HGRATE.KL=HGK*HASEN.K      HASENGEBURTENRATE
        

    5.6    S Supplementary
           ---------------
    Supplementary Gleichungen sind Gleichungen fr Hilfsvariablen,
    die nur zur Plot- oder Printausgabe bentigt werden.

    
    5.7    T Tabellendefinition
           --------------------
    In T-Zeilen werden mehrere Zahlenwerte unter einen Namen
    zusammengefat.Die Zahlen knnen durch ein Komma oder das
    Divisionszeichen getrennt werden.

        Bsp.:  T    TABELLE=1.2,2,3E4/56
        
    Auf die einzelnen Werte der Tabelle werden durch die Namen
    TABELLE(1),TABELLE(2) usw. angesprochen.
    Tabellen werden auch fr Funktionen bentigt wie TABLE.
    
        
           
    5.8    PRINT Printanweisung
           --------------------
    Um mit 'Printen' oder 'Drucken' Werte ausgeben zu knnen, mu
    sich im Listing eine PRINT-Anweisung befinden.
    Es werden maximal 7 Variablen gleichzeitig ausgegeben.
    Die Variablen knnen durch ein Komma oder den Schrgstrich
    getrennt werden.

        Bsp.:  PRINT   HASEN,FUECHS
        
    Die Variable PRTPER gibt an, nach wieviel Zeiteinheiten eine
    Ausgaben erfolgen soll.Wird PRTPER kein Wert zugewiesen, so
    erfolgt bei jedem Durchlauf eine Ausgabe.


    5.9    PLOT  Plotanweisung
           -------------------
    Um mit 'Plotten' oder 'DPlott' eine Ausgabe zu erhalten,mu
    sich im Listing eine PLOT-Zeile befinden.
   
         Bsp.:  PLOT  A=I(10,20),B=J

    In diesem Beispiel sind A und B definierte Variablen aus
    dem Dynamoprogramm.Die Buchstaben hinter dem Gleichheitszeichen
    sind der Syntax nach erforderlich aber hier ohne Bedeutung.
    Der Bereich in den Klammern (hier 10-20) gibt den Plottbereich
    der Variablen an.Wird kein Bereich angegeben,so versucht Dynamo
    einen geeigneten Bereich selbst zu finden.
    Weiteres hierzu unter dem Menpunkt 'Autoskal' und unter 3.5.
    
    Die Variable PLTPER gibt an, nach wieviel Zeiteinheiten eine
    Ausgabe erfolgen soll.Wird PLTPER kein Wert zugewiesen,so 
    erfolgt bei jedem Durchlauf eine Ausgabe.
    
    
    5.10   NOTE  Kommentar
           ---------------
    NOTE-Zeilen sind reine Kommentarzeilen und haben keine Auswirkung
    auf das Programm oder die Laufzeit.
    
       
    5.11   SPEC  Laufanweisung
           -------------------
    Die Laufanweisung darf nur einmal pro Programm benutzt werden.
    Sie spezifiziert die Systemkonstanten DT,LENGTH,PRTPER,PLTPER
    
    5.12   M   Regler
           ----------
    M ist keine in Dynamo festgelegte Zeilenkennung.Sie wurde 
    hinzugefgt um interaktiv im Programmablauf eingreifen zu knnen.
    Es knnen bis zu 2 Variablen deklariert werden.Die gre der
    Variablen kann mit der Maus verndert werden.Die Werte werden
    in einem eigenem Fenster ausgegeben.
    Die Notation ist mit der Notation fr Plotzeilen identisch.
    
        Bsp.: M   A=I(0,10)/B=J(-5,14)
        
    A nimmt also Werte von 0 bis 10 an, B von -5 bis 14.
 

    
    6.     Sprachkonventionen fr Level und Rates :
           ----------------------------------------

    Die verstrichene Zeit wird in Dynamo immer mit DT bezeichnet,
    also der Zeitabstand bis zur nchsten Berechnung.
    Der Zeitpunkt 'jetzt' wird durch ein angehngtes .K bezeichnet.
    Der Zeitpunkt 'vorher' wird durch ein angehngtes .J bezeichnet.
    



             |                 |                |
             |<-- Zeitraum  -->|<-- Zeitraum -->|
             |       .JK       |      .KL       |
             |                 |                |
       ------|-----------------|----------------|---------> Zeit
             |                 |                |
            .J                .K               .L
             |                 |                |
             |<----- DT ------>|<------ DT ---->|
          vorher             jetzt            spter

   

    Die Endungen .K,.L,.JK usw. sind nicht unbedingt notwendig.
    
    
    6.1   Wie werden die einzelnen Gleichungen berechnet ?
          ------------------------------------------------
    Reihenfolge der Berechnung :
     
       1. Level-Gleichungen
       2. Auxiliaries
       3. Raten-Gleichungen
       
    Zum Berechnen der Level-Gleichungen zum Zeitpunkt .K werden die
    Level zum Zeitpunkt .J,die Auxiliaries zum Zeitpunkt .J und die
    Rates fr den Zeitraum .JK benutzt.
    
    Zum Berechnen der Auxiliaries zum Zeitpunkt .K werden die Level
    zum Zeitpunkt .K, die Auxiliaries zum Zeitpunkt .K und die
    Rates im Zeitpunkt .JK benutzt.

    Achtung : Es werden die Auxiliaries zum Zeitpunkt .K benutzt !
              Werden in einer Auxiliarie-Gleichung Auxiliaries
              benutzt,mssen diese erst berechnet werden.
              Simultane Gleichungssysteme sind also nicht erlaubt!
              Z.B. NICHT :
                     A   A.K = B.K
                     A   B.K = A.K

    Zuletzt werden die Rates fr den Zeitraum .KL berechnet.
    Dazu werden die Rates fr den Zeitraum .JK,die Auxiliaries zum
    Zeitpunkt .K und die Level zum Zeitpunkt .K benutzt.
    

    7.      Syntax und eingebaute Funktionen :
            ----------------------------------
            
    Mathematische Funktionen :                         

    ABS         Absolut Betrag                         
    COS         Cosinus Funktion                        
    SIN         Sinus Funktion
    TAN         Tangens Funktion
    EXP         Exponential Funktion
    LN          Logarithmus Funktion
    MAX         Maximum zweier Zahlen      
    MIN         Minimum zweier Zahlen
    SQRT        Wurzelfunktion
    

    Spezielle Dynamo-Funktionen :
    
   -  CLIP(P,Q,R,S)  oder  FIFGE(P,Q,R,S)  (First if greater or equal)
        R >= S  ==>  CLIP(P,Q,R,S) = P
        R  < S  ==>  CLIP(P,Q,R,S) = Q
        
      Die Funktion hat P als Ergebnis falls R grer oder gleich S ist,
      ansonsten ist Q das Ergebnis.P,Q,R,S knnen auch Ausdrcke sein.
      
   -  NOISE(0)
        Es wird eine Zufallszahl zwischen -0.5 und 0.5 geliefert.
        Der Parameter hat keine Bedeutung.
        
   -  PULSE(HEIGHT,FIRST,INTERVAL)
        Es wird ein rhythmische Impuls der Hhe HEIGHT erzeugt.
        Der erste Impuls erfolgt zum Zeitpunkt FIRST.Weitere Impulse
        erfolgen in einem Zeitabstand von INTERVAL.
        Also FIRST+INTERVAL,FIRST+2*INTERVAL usw.
        
   -  RAMP(SLOPE,START)
        TIME <  START   ==>  RAMP=0
        TIME >= START   ==>  RAMP=SLOPE*(TIME-START)
        
   -  STEP(HEIGHT,STEPTIME)
        TIME <  STEPTIME  ==>  STEP=0
        TIME >= STEPTIME  ==>  STEP=HEIGHT
        
   -  SWITCH(P,Q,R)  oder  FIFZE(P,Q,R)    (First if zero)
        R =  0  ==>  SWITCH=P
        R <> 0  ==>  SWITCH=Q
                
   -  TABLE(NAME,X,XUNTEN,XOBEN,XZWISCHENRAUM)
        NAME ist der Tabellenname
        XUNTEN der kleinste Wert
        XOBEN  der grte  Wert
        XZWISCHENRAUM die Schrittweite
        X der Name der unabhngigen Variablen
        
        
        Bsp.:   
        T   YTABELLE=20,10,5,1                   
        A   Y.K=TABLE(YTABELLE,X.K,1,4,1)
       
        Zuordung :     
        
        YTABELLE | 20 | 10 |  5 |  1
        -----------------------------
            X    | 1  |  2 |  3 |  4
        
        Nimmt X Zwischenwerte an, so wird interpoliert.
        X.K=1.5 so wird linear interpoliert und Y.K=15 gesetzt.
        Wenn x<xunten ,so wird konstant der Wert von xunten geliefert.
        Wenn x>xoben  ,so wird konstant der Wert von xoben geliefert.
        

    8.  Makrodefinition
    -------------------
    
        Mit Makros knnen eigene Funktionen definiert werden.
        Makros werden textuell bei einem Aufruf ersetzt.
        Makros beginnen mit einer MACRO Zeile und enden mit einer
        MEND Zeile.
        In der MACRO Zeile steht der Funktionsname und die Parameterliste.
        
        Bsp.:
             MACRO DELAY1(IN,DEL)
             A     DELAY1.K=$LV.K/DEL
             L     $LV.K=$LV.J+DT*(IN.JK-DELAY1.J)
             N     $LV=DEL*IN
             MEND
             
        Es knnen lokale Variablen benutzt werden.Diese Variablen
        haben als Kennung ein $-Zeichen.Bei der textuellen Ersetzung
        werden sie durch neue Namen ersetzt.
    
        
    9.  Makrobibliothek
    -------------------
    
        Hufig benutzte Makros knnen in der Bibliothek abgelegt werden.
        Wird die Bibliothek aktiviert,so knnen die Makros wie 
        normale Funktionen benutzt werden.
        Achtung : Nach dem Start von Dynamo ist die Bibliothek nicht
        eingeschaltet.Verwendet ein Programm dennoch Funktionen aus der 
        Bibliothek, so kommt es natrlich zu Fehlermeldungen !
        
        In dieser Bibliothek befinden sich DELAY-Funktionen und die
        SMOOTH-Funktionen.
        Delay-Funktionen sind Verzgerungsfunktionen.
        SMOOTH(IN,DEL) :
        Der Eingabewert IN wird exponentiell geglttet mit der 
        Glttungskonstanten DEL.
        
        Diese Bibliothek kann natrlich nach den eigenen Bedrfnissen
        angepat werden.
        Ist die Bibliothek geladen,so hat ein ndern der Bibliothek
        keine Auswirkungen.Dynamo mu zuerst neu gestartet werden !
        


    10. Literatur :
    ---------------
    
    D.Craemer
    Mathematisches Modellieren dynamischer Vorgnge
    Teubner Verlag
    
    Pugh,Alexander L.
    Dynamo II User's Manual
    MIT Press
    
    Forrester,JW
    World dynamics
    MIT Press
    
    Hans Rauch
    Modelle der Wirklichkeit
    Heise Verlag

    Eckart Zwicker
    Simulation und Analyse dynamischer Systeme
    de Gruyter Verlag
    
   

    Dieses Programm ist Public Domain und kann somit beliebig oft
    kopiert und weitergegeben werden ! Hinzufgen von Dynamoprogrammen
    ist erwnscht !

    Interesse an besseren Versionen ?
    Fehler gefunden ?
    
    Schreiben Sie an : 

                    J.Engbers
                    Holtestr.8
                 4600 Dortmund 72


                             --- ENDE ---
                     

