 (3)                    Libraryfunktionen

NAME
   PROCEDURE fly.wd_install
   PROCEDURE fly.wd_deinstall
   PROCEDURE fly.wd_close_all
   FUNCTION fly.wd_suche_dialog(baum&)
   FUNCTION fly.wd_add_dialog(baum&,titel$)
   FUNCTION fly.wd_release_dialog(baum&)
   PROCEDURE fly.wd_center(w,h,VAR x,y)
   FUNCTION fly.wd_m_redraw(handle,area_x,area_y,area_w,area_h)
   FUNCTION fly.wd_m_topped(handle)
   FUNCTION fly.wd_m_fulled(handle)
   FUNCTION fly.wd_m_closed(handle,VAR baum&)
   FUNCTION fly.wd_m_arrowed(handle,typ)
   FUNCTION fly.wd_m_hslider(handle,pos)
   FUNCTION fly.wd_m_vslider(handle,pos)
   FUNCTION fly.wd_m_sized(handle,x,y,w,h)
   FUNCTION fly.wd_m_moved(handle,x,y,w,h)
   PROCEDURE fly.wd_redraw_dialog(adr,work_x,work_y,box_x,box_y,box_w,box_h)
   FUNCTION fly.wd_evnt_button(mx,my,state,shift,clicks,VAR baum&,end_ob&)
   FUNCTION fly.wd_evnt_keybd(code&,shift&,VAR baum&,ob&)
   PROCEDURE fly.wd_justate(baum&,VAR aus_w,aus_h)

BESCHREIBUNG
   Eine auf den Flys basierende Fensterdialoglibrary.
   Zur Identifizierung der einzelnen Dialoge dienen Fensterhandles und
   Objektbaumnummern.
   Es ist nicht mglich, einen Dialog mehrfach nebeneinander zu ffnen,
   da intern keine Kopie des Objektbaums angelegt wird (das Problem liegt
   bei der Speicherverwaltung, denn das BS vertrgt nicht beliebig viele
   Mallocs, und eine eigene Speicherverwaltung einzubauen? Nein danke,
   da fehlt mir die rechte Lust zu).
   Die Anzahl mglicher Fenster (=F-Dialoge) ist derzeit auf zehn begrenzt,
   aber das kann man leicht ndern (eine Variable in fly.wd_install ndern
   und den dortigen INLINE anpassen). _Ich_ kann zwar mit dynamischen Listen
   umgehen, aber Bugsic kann es nicht.

   PROCEDURE fly.wd_install
      Installiert die Fensterdialoge. Sollte erst nach Initialisierung der
      Flys laufen.

   PROCEDURE fly.wd_deinstall
      Schliet und lscht alle Fensterdialoge, lscht die angelegten Felder
      und Variablen.

   PROCEDURE fly.wd_close_all
      Alle Fensterdialoge schlieen.

   FUNCTION fly.wd_suche_dialog(baum&)
      Liefert das Handle des Fensters zurck oder 0, wenn der Dialog nicht
      auf dem Bildschirm ist. Damit kann man also erfahren, ob ein bestimm-
      ter Dialog geffnet ist.

   FUNCTION fly.wd_add_dialog(baum&,titel$)
      Ein Dialog wird geffnet, der Titelstring in die Titelzeile des
      Fensters eingetragen. Kann der Dialog nicht geffnet werden, wird
      0 zurckgegeben. Mglicherweise ist kein Fenster mehr frei.
      Titel$ darf 79 Zeichen lang sein.
      btw: Es wre auch mglich, eine Infozeile zu installieren. Allerdings
      kostet das pro maximal mglichem Fenster 80 Byte und einen erheblichen
      teil der Bildschirmflche.
      Seit Version 0.21 wird der Titelstring auch tatschlich dargestellt,
      vorher klappte das nur in der Theorie.

   FUNCTION fly.wd_release_dialog(baum&)
      Ein Dialog wird geschlossen.

   PROCEDURE fly.wd_center(w,h,VAR x,y)
      Zentriert das Fenster um die Maus herum (das knnte ich einstellbar
      machen, wenn es jemand braucht).

   FUNCTION fly.wd_m_redraw(handle,area_x,area_y,area_w,area_h)
      Eine Redrawmessage fr Fenster "handle", Bereich xywh ist eingetroffen.
      Die Funktion liefert 0 zurck, wenn kein Fensterdialog betroffen war.
      (Mit anderen Worten: Wird ein Wert ungleich 0 zurckgeliefert, braucht
      sich das Hauptprogramm nicht mehr um den Redraw des Fensters kmmern)

   FUNCTION fly.wd_m_topped(handle)
      Eine WM_TOPPED-Message ist eingetroffen.
      RETURN = 0, wenn kein Fensterdialog betroffen ist.

   FUNCTION fly.wd_m_fulled(handle)
      Eine WM_FULLED-Message ist eingetroffen (derzeit knnen Fensterdialoge
      nicht vergrert/verkleinert werden, auf diese FUnktion knnte man also
      verzichten).
      RETURN = 0, wenn kein Fensterdialog betroffen ist.

   FUNCTION fly.wd_m_closed(handle,VAR baum&)
      Eine WM_CLOSED-Message fr Fenster "handle" ist eingetroffen. Ist kein
      Fensterdialog betroffen, wird 0 zurckgegeben.
      Ist ein Fensterdiolog betroffen, wird in baum& die Nummer des Objekt-
      baums eingetragen und ein Wert ungleich 0 zurckgeliefert.
      Bemerkung: Wie ein Click auf den Closer zu bewerten ist, wei ich nicht
        sicher (kein Standard). Ich werte es als "Abbruch".

   FUNCTION fly.wd_m_arrowed(handle,typ)
      Eine WM_ARROWED-Message ist eingetroffen (derzeit haben Fensterdialoge
      keine Pfeile, auf diese Funktion knnte man also verzichten).
      RETURN = 0, wenn kein Fensterdialog betroffen ist.

   FUNCTION fly.wd_m_hslider(handle,pos)
      Eine WM_HSLID-Message ist eingetroffen (derzeit haben Fensterdialoge
      keine Slider, auf diese Funktion knnte man also verzichten).
      RETURN = 0, wenn kein Fensterdialog betroffen ist.

   FUNCTION fly.wd_m_vslider(handle,pos)
      Eine WM_VSLID-Message ist eingetroffen (derzeit haben Fensterdialoge
      keine Slider, auf diese Funktion knnte man also verzichten).
      RETURN = 0, wenn kein Fensterdialog betroffen ist.

   FUNCTION fly.wd_m_sized(handle,x,y,w,h)
      Eine WM_SIZED-Message ist eingetroffen (derzeit knnen Fensterdialoge
      nicht vergrert/verkleinert werden, auf diese Funktion knnte man also
      verzichten).
      RETURN = 0, wenn kein Fensterdialog betroffen ist.

   FUNCTION fly.wd_m_moved(handle,x,y,w,h)
      Eine WM_MOVED-Message ist eingetroffen. Rckgabewert 0 signalisiert,
      da kein Fensterdialog gemeint war.

   PROCEDURE fly.wd_redraw_dialog(adr,work_x,work_y,box_x,box_y,box_w,box_h)
      Interne Unterroutine. Zeichnet den Objektbaum an "adr" neu.
      work_x und -y geben die linke obere Ecke des Objektbaums an, box_*
      ist das Clippingrechteck.

   FUNCTION fly.wd_evnt_button(mx,my,state,shift,clicks,VAR baum&,end_ob&)
      Ein Mausbuttonevent ist eingetroffen. Rckgabewert 0 zeigt an, da
      der oben liegende Fensterdialog nicht betroffen war.
      Eingangsparameter:
        mx,my: Mausposition zum Zeitpunkt des Events
        state: Maustastenstatus
        shift: Umschalttastenstatus
        clicks: Anzahl der Clicks
      Ausgangsparameter:
        baum&:  War ein Fensterdialog gemeint, wird hier die Nummer des
                Objektbaums eingetragen. Falls aber ein nicht whlbares
                Objekt gemeint gewesen ist, wird baum& auf 0 gesetzt.
        end_ob&:War ein Fensterdialog gemeint, wird hier die Nummer des
                Objekts eingetragen (end_ob&=0 gilt, wenn das Objekt
                kein Exitobjekt war).
        Leider bedeutet diese Art der Parameterrckgabe, da ein
        Fensterdialog mit Baumnummer 0 keine gute Idee wre!

   FUNCTION fly.wd_evnt_keybd(code&,shift&,VAR baum&,ob&)
      Ein Keyboardevent ist eingetroffen. Rckgabewert 0 zeigt an, da
      der oben liegende Fensterdialog nicht betroffen war.
      Eingangsparameter:
         code&:   Tastencode, wie er z.B. von EVNT_KEYBD oder EVNT_MULTI
                  zurckgeliefert wird.
         shift&:  Umschalttastenstatus wie von ENVT_BUTTON oder EVNT_MULTI.
      Ausgangsparameter:
         baum&:   Baumnummer des betroffenen Baumes
         ob&:     Entweder 0 oder die Nummer eines (gewhlten) EXIT-Objekts.
      Bemerkung:  Weil nicht geklrt ist, ob Menleistenshortcuts oder
                  Dialogshortcuts vorzuziehen sind, habe ich mich entschie-
                  den, in Fensterdialogen keine Shortcuts zu untersttzen
                  (obwohl das nicht kompliziert wre).

   PROCEDURE fly.wd_justate(baum&,VAR aus_w,aus_h)
         interne Angelegenheit.

BEISPIELE
   siehe flydemo. Hier nur kurz eine mgliche Eventbehandlung in Pseudocode:
   Wenn Event-xyz eingetroffen,
     dann wenn FN fly.wd_evnt-xyz(irgendwas) null zurckliefert
         dann mu das Hauptprogramm selbst den Event behandeln.

AUTOR
   Uwe Ohse, 1992

BEMERKUNGEN
   Ich betracht die Fensterdialoge nur als nette Zulage und werde nur daran
   arbeiten, wenn mir gerade danach ist! Der Hauptgrund dafr ist, da sich an
   diversen Stellen die fehlende Untersttzung durch das Betriebssystem
   "bemerkbar" macht.

