flys (3)                    Libraryfunktionen

NAME
   FUNCTION fly_install(baum,radio_leer,radio_voll,circle)
   PROCEDURE fly_deinstall
   PROCEDURE fly_getversion(VAR version#,datum$)
   PROCEDURE fly_conf_centermode(mouse!,merken!)
   PROCEDURE fly_get_centermode(VAR mouse!,merken!)
   PROCEDURE fly_get_shortcutcolor(VAR unterstrichfarbe)
   PROCEDURE fly_conf_shortcutcolor(unterstrichfarbe)
   FUNCTION fly_form_dial(flag,x1,y1,w1,h1,x2,y2,w2,h2)
   FUNCTION fly_objc_draw(adr,start,mdepth,cx,cy,cw,ch)
   FUNCTION fly_form_do(adr,start)
   FUNCTION fly_objc_change(adr,nr,dummy,x,y,w,h,status,modus)
   FUNCTION fly_form_center(adr,VAR x,y,w,h)
   FUNCTION fly_form_button(adr,ob,clicks,VAR next&)
   PROCEDURE fly_popup(adr,nr,VAR akt,a$())
   PROCEDURE fly_circle(adr,nr,VAR akt,a$())
   PROCEDURE fly_form_continue(contmode!)
   PROCEDURE fly_vget(x1,y1,x2,y2,VAR image)
   PROCEDURE fly_vput(x,y,image)
   PROCEDURE fly_vcopy(x1,y1,x2,y2,x3,y3)
   PROCEDURE fly_sget(VAR image)
   PROCEDURE fly_sput(image)

BESCHREIBUNG

  Die verfgbaren Funktionen:
    FUNCTION fly_install(baum,radio_leer,radio_voll,circle)
      Initialisiert die Flydials.
      baum%:      Objektbaum, in dem einige fr die Flys unbedingt ntige
                  Objekte sind, nmlich:
      radio_leer: Objektnummer des leeren (nicht gewhlten) Radiobuttons
      radio_voll: analog dazu der angewhlte Radiobutton
      circle:     Circlebutton.
      An einfachsten ist es, den Objektbaum aus Flydemo.Rsc zu kopieren.
      Rckgabe: 0 -> Fehler, Library nicht initialisiert.

    PROCEDURE fly_deinstall
      Die Library gibt etwaigen allozierten Speicher frei und lscht
      diverse Verwaltungsinformationen.

    PROCEDURE fly_getversion(VAR version#,datum$)
      Ermitteln Versionsnummer und -datum.

    PROCEDURE fly_conf_centermode(mouse!,merken!)
      konfiguriert den Zentrierungsmodus.
      mouse! = TRUE  -> es wird um die Maus herum zentriert
             = FALSE -> es wird in der Bildschirmmitte zentriert
      merken!= TRUE  -> ein Dialog taucht an seiner letzten Position
                        wieder auf.
             = FALSE -> bei jedem Aufruf eines Dialogs wird neu
                        zentriert.
      (Default: TRUE, FALSE)

    PROCEDURE fly_get_centermode(VAR mouse!,merken!)
      holt den aktuellen Zentriermodus.

    PROCEDURE fly_get_shortcutcolor(VAR unterstrichfarbe)
      holt die aktuelle Farbe des Strichs unter den Shortcuts.
      (Default: Rot bei Farbauflsungen, sonst Schwarz)

    PROCEDURE fly_conf_shortcutcolor(unterstrichfarbe)
      setzt die Farbe des Strichs, mit dem die Shortcuts verziert werden.

    FUNCTION fly_form_dial(flag,x1,y1,w1,h1,x2,y2,w2,h2)
      Ersatz fr FORM_DIAL. Im Gegensatz zum Original ist fly_form_dial(0,...)
      jedoch keine Dummyfunktion, sondern dient der Pufferung des Bildhinter-
      grundes. Also: bevor ein Dialog auf den Bildschirm gebracht wird, mu
      fly_form_dial aufgerufen werden.

    FUNCTION fly_objc_draw(adr,start,mdepth,cx,cy,cw,ch)
      Ersatz fr objc_draw. Kann natrlich deutlich mehr :-)
      nebenbei: AES-objc_draw kann nur 7 Objektebenen verwalten und strzt
      dann ab. fly_objc_draw wird in der Beziehung nur vom freien Speicher
      begrenzt ;-)

    FUNCTION fly_form_do(adr,start)
      Ersatz fr FORM_DO.

    FUNCTION fly_objc_change(adr,nr,dummy,x,y,w,h,status,modus)
      Ersatz fr OBJC_CHANGE.

    FUNCTION fly_form_center(adr,VAR x,y,w,h)
      Ersatz fr FORM_CENTER

    FUNCTION fly_form_button(adr,ob,clicks,VAR next&)
      Ersatz fr FORM_BUTTON

    PROCEDURE fly_popup(adr,nr,VAR akt,a$())
      Ein Popupmen wird ber einem Circlebutton dargestellt.
      adr:     Adresse des Objektbaums
      nr:      Objektnummer
      akt:     Index des aktuellen Objekts in a$()
      a$():    Stringfeld mit den darzustellenden Strings.
      Vor Rckkehr aus der Funktion wird der richtige Text im Circlebutton
      eingetragen und dargestellt.
      Gedacht ist dies fr die Darstellung von Circlebuttons. Dazu rufe ich
      die Funktion mit folgenden Parametern auf:
         - aktueller Objektbaum
         - Textfeld des Circlebuttons
         - Nummer des Strings in a$(), der gerade dargestellt wird.
         - das Stringfeld selbst.
      hnlich einfach knnte man auch Routinen fr Popups mit anderen
      Elementtypen, z.B. Icons, aufbauen.
      brigens wird fly_circle aufgerufen, um zum Schlu den neuen Eintrag
      anzuwhlen.

    PROCEDURE fly_circle(adr,nr,VAR akt,a$())
      Bewegt einen Circlebutton um eine Position weiter. Parameter wie oben.
      Fly_circle kommt mit folgenden Objekttypen klar:
      21 G_TEXT
      22 G_BOXTEXT
      26 G_BUTTON
      27 G_BOXCHAR (wozu auch immer :-)
      29 G_FTEXT
      30 G_FBOXTEXT


    PROCEDURE fly_form_continue(contmode!)
      Normalerweise wrde bei jeder Aufruf von fly_form_do der Cursor wieder
      auf das Startobjekt gesetzt. Dies ist ein Feature des AES und fllt mit
      der Benutzung von Circlebuttons unangenehm auf. Wer will, kann dies mit
      Hilfe von fly_form_continue ndern.
      Dazu wird die Funktion mit TRUE als Argument aufgerufen. Beim nchsten
      (und nur bei diesem!) Aufruf von fly_form_do wird nun der Cursor nicht
      zurckgesetzt. fly_form_continue(FALSE) sorgt dafr, da der Cursor beim
      nchsten Aufruf neu initialisiert wird.
      fly_form_continue(TRUE) darf nur dann eingesetzt werden, wenn
      a) das gerade aktuelle Editierfeld NICHT gendert wurde, und
      b) der Cursor fr diesen Dialog schon einmal initialisiert wurde (also
         schon ein fly_form_do fr diesen Dialog aufgerufen wurde).

    PROCEDURE fly_vget(x1,y1,x2,y2,VAR image)
    PROCEDURE fly_vput(x,y,image)
    PROCEDURE fly_vcopy(x1,y1,x2,y2,x3,y3)
    PROCEDURE fly_sget(VAR image)
    PROCEDURE fly_sput(image)
      GET, PUT, RC_COPY, SGET und SPUT fallen wegen Benutzung von LINEA und
      der Beschrnkung auf Strings von bis zu 32K Lnge fr die Library aus.
      Deshalb wurden diese Ersatzfunktionen implementiert.
      fly_vget ersetzt GET und hat hnliche Parameter. Einziger Unterschied
      ist, da der String durch eine Adresse ersetzt werden mu. Deshalb
      vertrgt fly_vget auch Images ber 32 K.
      fly_vput ist das Gegenstck zu PUT.
      fly_copy kopiert den Bereich (x1,y1) (x2,y2) an die Position (x3,y3).
      Wird ein Image nicht mehr bentigt, mu der Speicherblock mit
      MFREE(adresse%) wieder freigegeben werden.

      Liefern fly_vget und fly_sget als Adresse des Images 0 zurck,
      konnte die Aktion nicht durchgefhrt werden.

  Die erweiterten Objekttypen
    Die Library erkennt an den erweiterten Objekttypen, welche Objekte
    nicht vom AES, sondern von ihren eigenen Funktionen gezeichnet und
    behandelt werden mssen.
    Folgende erweiterte Objekttypen stehen zur Verfgung:

    Mover (erweiterter Objekttyp 17)
      Diese Objekte machen einen Dialog verschiebbar. Als Flugobjekt drfen nur
      G_IBOXen (AES-Objekttyp 25) verwendet werden. Dieses Objekt darf an
      beliebiger Stelle im Dialog plaziert werden, da die Lib es automatisch
      an die richtige Position (rechts oben) setzt.
      (Es entsteht das "Eselsohr")

    neue Buttons (erweiterter Objekttyp 18)
      (nur fr Buttonobjekte!)
      Ist im Buttontext ein '[', so wird dieses nicht gezeichnet und das
      nachfolgende Zeichen als Shortcut (Tastaturkrzel) betrachtet. Der Button
      kann durch ALTERNATE und diese Taste angewhlt werden.
      Erlaubte Zeichen sind: A-Z (gleich a-z), 0-9 (nicht die Zahlen des
      Zifferblocks, da diese in neueren TOS-Versionen im Zusammenhang mit der
      ALT-Taste zur Eingabe von Sonderzeichen dienen).
      Umlaute drfen nicht als Shortcuts benutzt werden.

      Fr Cross- und Radiobuttons gilt:
        Der Buttontext wird links neben dem Knopf gezeichnet. Er sollte er
        keine Leerzeichen am Anfang haben, da die Library den Text automatisch
        richtig setzt.
        Der Button sollte drei Zeichen lnger sein als sein Text! Anderenfalls
        kommt es zu Problemen mit OBJC_FIND (der von der Library intern genutzt
        wird), und die letzten Buchstaben des Buttons knnen nicht mit der Maus
        angeklickt werden.

      a) Radiobuttons
        Die Objektflags 'Selectable' und 'Rbutton' mssen gesetzt sein.
        Es wird ein runder Knopf gezeichnet, der ausgefllt wird, wenn das
        Objekt den Status 'angewhlt' hat.
        Sollte alte und neue Radiobuttons in einer Dialogebene verwendet werden,
        so werden nur die Buttons des gewhlten Typs bei einer Anwahl gendert.

      b) Crossbuttons
        Das Objektflag 'Selectable' mu gesetzt sein.
        Es wird eine quadratische Box gezeichnet. Sie wird angekreuzt, wenn der
        der Button angewhlt wird.

      c) Exitbuttons
        (also die, mit denen der Dialog verlassen werden kann)
        Die Objektflags 'Selectable' und 'Exit' mssen gesetzt sein.


    Erweiterte Texteffekte (erweiterter Typ 19)
      (nur fr Strings [GEM-Objekttyp 25])
      Je nach Objektstatus wird ein String mit verschiedenen Effekten
      gezeichnet. Sie knnen (mit Ausnahme des 3D-Effektes) vermischt werden.
      Selected:    invertiert.
      Disabled:    hell.
      Shadowed:    unterstrichen
      Outlined:    doppelt unterstrichen
      checked:     Kleinschrift
      draw3d:      fett
      crossed:     Drei-D-Effekt, erzeugt durch mehrfaches Zeichnen des
                   Strings. Sehr langsam (alte RSCs: Objektstatus State6)
      Hinweis: Die etwas gewhnungsbedrftige Zuordnung von Status und Effekt
      ist nicht meine Idee gewesen, ich habe sie nur bernommen, um mit der
      Magiclib von Peter Hellinger (welche fr Modula- und Pascalprogrammierer
      SEHR zu empfehlen ist) kompatibel zu bleiben.
      [Anmerkung: So ganz ist mir dies nicht gelungen, da ich in den Circle-
      buttons noch den Selector eingebaut habe. Dieser wird von der mir
      vorliegenden Magicversion nicht untersttzt. Ich sah Rufus 1.10 und
      konnte nicht wiederstehen, verzeiht!]

    3.4 Rahmen (erweiterter Typ 20)
      (nur fr Buttons, GEM-Objekttyp 26)
      Es wird ein Rahmen mit den Ausmaen des Buttons gezeichnet. Auf die obere
      Linie wird der Buttontext (mit den Effekten wie unter 3.3, mit Ausnahme
      von 'crossed', durch den der String zentriert wird).
      Ntzlich sind solche Rahmen fr die Trennung von nicht zusammengehrigen
      Radiobuttons oder um Funktionsgruppen ins groen Dialogen optisch zu
      trennen.

    3.5 Circlebutton (erweiterter Typ 25)
      (Objekttyp 27 fr Circler, 26 fr Text, 28 fr den Selector)
      Wird benutzt, um irgendetwas weiterzuschalten. (Demoprogramm ansehen, die
      Beschreibung ist zu kompliziert).
      Der Circler, also das Objekt, in das der Kreis eingezeichnet wird, _mu_
      vom Typ 27 sein. Der Text mu in einem Buttonobjekt (=26) sein!
      Beide Objekte mssen selectable sein!

      Der Selector ist optional und ist ein normaler String (=28). Er sollte
      nicht SELECTABLE, sondern TOUCHEXIT sein.

      Die FLYS-Library stellt zwei Funktionen zur Verfgung, die dem
      Programmierer die Mehrarbeit abnehmen:
      fly_popup(adr,nr,akt,a$())
      fly_circle(adr,nr,akt,a$())

      Es empfiehlt sich, das Demoprogramm anzusehen! Durch die Benutzung der
      beiden Prozeduren wird die Handhabung der Circlebuttons sehr einfach.

  ber diverse Interna:
    - Die Library benutzt eine eigene virtuelle VDI-Workstation und ist
      durch von irgendwelchen Attributen des Hauptprogramms unabhngig.
      Ich bitte auch darum, da niemand von auerhalb irgendwelche
      Attribute der Flys-Workstation verstellt!
    - alle globalen Variablen der Library (und das sind einige!) beginnen
      mit "fly_". Sie sollten auerhalb der Library nicht benutzt werden.

  ber die Flugroutinen:
    Das Verschieben von Dialogen ist nichts weiter als eine Hufung von
    VDI-Rasterkopieraktionen. Im Prinzip ist das Vorgehen erstaunlich einfach.

    Die Fls untersttzen derzeit drei verschiedene Flugmodi:
    a) Fast Fly
      Dazu mu es mglich sein, einen Spicherblock von den Ausmaen
      des Bildschirms zu allozieren. Diese Flugroutine ist die bisher
      schnellste, die ich kenne.
      Das liegt daran, da ich verschwenderisch mit dem Speicher umgehe, denn
      dieser Modus bentigt einen allozierbaren Speicherblock von
      Bildschirmgre. Dies ist unter dem derzeitigen TOS nicht weiter schlimm
      und drfte selbst unter einem Multitaskingbetriebssystem nicht weiter
      tragisch sein, da die Fliegerei nicht lange dauert.
      Reicht der Speicher nicht aus, so bleibt immer noch Modus b.
    b) Hollow1
      Hier wird nur ein Speicherblock von der Gre der Dialogbox
      bentigt, in den diese auch gleich kopiert wird.
      Es wird hierbei nicht der Dialog, sondern nur ein Geisterrahmen
      verschoben.
      Reicht auch hierfr der Platz nicht, bleibt immer noch Modus c.
    c) Hollow2
      Auch hier wird nicht der Dialog, sondern nur ein Rahmen
      verschoben. Am Ende des Flugs wird die Dialogbox durch fly_objc_draw
      neu gezeichnet.

    Es kann nur dann berhaupt verschoben werden, wenn bei fly_form_dial(start)
    noch gengend Speicher frei war, um den Hintergrund der Dialogbox zu
    puffern. Ebenso kann der Dialog auch nur dann unsichtbar gemacht werden.

  Programmierhinweise
  - Sollten Unterdialoge aufgerufen werden, also ein Dialog ber einen anderen
    gelegt werden, MU nach Rckkehr aus dem Unterdialog der Dialog noch
    einmal mit OBJC_DRAW gezeichnet werden. Dies ist notwendig fr den Fall,
    das der Hintergrund des U-Dialogs wegen Speicherplatzmangel nicht
    gepuffert werden konnte und FORM_DIAL 'einspringen' mute.
  - Sollte ein Objekt nicht gezeichnet werden, liegt das wahrscheinlich daran,
    da erweiterter Objekttyp und normaler Objekttyp nicht zueinanderpassen.
  - Es mu gengend freier GEMDOS-Speicher frei sein, damit die Dialoge
    verschoben werden knnen (mittels RESERVE).
  - Vor Aufruf irgendwelcher Dialoge mu EINMAL die Prozedur fly_install
    aufgerufen werden. Sie initialisiert mehrere Felder und ffnet eine
    VDI-Workstation.
  - Vor Programmende mu unbedingt die Procedure fly_deinstall aufgerufen
    werden. Sie gibt die Workstation und eventuell auch etwaiges alloziertes
    Ram wieder frei. Es ist zu empfehlen, sie unbedingt im Unterbrechungs-
    oder Fehlerfall aufzurufen, z.b. mit:
    ON ERROR GOSUB fly_deinstall
    ON BREAK GOSUB fly_deinstall
  - die FORM_DIAL-Aufrufe mssen durch fly_form_dial ersetzt werden.
  -  "  FORM_DO      "       "     "   fly_form_do      "       ".
  -  "  OBJC_DRAW    "       "     "   fly_objc_draw    "       ".
  -  "  OBJC_CHANGE  "       "     "   fly_objc_change  "       ".
  -  "  FORM_CENTER  "       "     "   fly_form_center  "       ".
  -  "  FORM_BUTTON  "       "     "   fly_form_button  "       ".
  -  "  FORM_DIAL    "       "     "   fly_form_dial    "       ".
    (die ersetzenden FUnktionen sind kompatibel zu den alten, ihre Argumente
    sind dieselben)
  - Eine Dialogbox mit erweiterten Typen sollte unbedingt mit den neuen
  Funktionen behandelt werden, sonst sieht das Ergebnis sehr hlich aus.
  Schlimmeres passiert aber nicht.

BEISPIELE
  siehe flydemo

AUTOR
  Uwe Ohse, 1991, 1992

SIEHE AUCH
  flywind.man

BEMERKUNGEN
  Trotz aller Bemhungen, die Library klein zu halten, ist sie doch recht gro
  geworden. Leider ist auch nicht viel einzusparen.
