finf (3)                    Libraryfunktionen

NAME
   finf steht fr flys.infofilebehandlung
   PROCEDURE finf.laden(fname$)
   PROCEDURE finf.speichern(fname$)
   PROCEDURE finf.freigeben
   PROCEDURE finf.unkomment(text$,VAR inhalt$,komment$)
   FUNCTION finf.get_var(such$,VAR result$)
   FUNCTION finf.read_first(VAR var$,wert$)
   FUNCTION finf.read_next(VAR var$,wert$)
   PROCEDURE finf.set_var(vname$,wert$)
   PROCEDURE finf.clear_var(vname$)

BESCHREIBUNG
   Die Routinen erleichtern die Behandlung von Infofiles. Sie pasden zwar gar
   nicht zu den Flugsauriern, aber ich hatte sie nun einmal geschrieben, und
   jetzt lege ich sie auch bei :-)

   Grundstzliches:
   - Es kann immer nur eine Infodatei behandelt werden (= geladen sein).
   - Infodateien knnen normalerweise nur 250 Zeilen lang sein, dies kann
     aber durch die Variable finf.max_lines (in finf.laden ndern!)
     konfiguriert werden.
   - Kommentarblcke beginnen und enden mit "##". Folgendes ist ein
     Kommentarblock:
         ## Anfang (schon Kommentar)
            _irgendein_tiefsinniges_Statement_ber_n_Zeilen_
         ## Ende (noch Kommentarzeile)
   - Leerzeilen werden als Kommentare aufgefasst.
   - Zeilen, deren erstes nicht-Leerzeichen ein '#' ist, sind Kommentarzeilen
         # Kommentar ist ebenso Kommentarzeile wie
            # Kommentar.
   - Alle anderen Zeilen sind keine Kommentare, knnen aber Kommentare bein-
     halten.
   - Das Zeichen " beginnt und beendet eine Quote. Quotes sind zusammen-
     gehrige Statements.
   - Das erste ungequotete # in eine Zeile leitet einen Kommentar ein.
         VAR=wert # Das ist eine Zuweisung, dies ein Kommentar
              (Kommentar ab #)
         VAR=wert "anything # irgendwas" # comment
              (Kommentar ist nur "comment")
    - "VAR=x" wird interpretiert als "VAR hat den Wert x"
    - "VAR=" wird interpretiert als "VAR ist gesetzt und leer"
         (man knnte das als Flag interpretieren)
    - "VAR" wird interpretiert wie "VAR="

   Um die Zugriffsgeschwindkeit zu erhhen, werden reine reine Kommentarzeilen
   schon beim Einlesen der Datei durch ein Flag kenntlich gemacht. Die Anzahl
   der Kommentarzeilen ist fr die Arbeitsgeschwindigkeit also unwesentlich.

   PROCEDURE finf.laden(fname$)
      Ldt die Infodatei, falls sie existiert.

   PROCEDURE finf.speichern(fname$)
      Speichert sie wieder ab.

   PROCEDURE finf.freigeben
      Lscht die internen Arrays.

   PROCEDURE finf.unkomment(text$,VAR inhalt$,komment$)
      Befreit eine Zeile von den Kommantaren, aus "abc # def" wird
      inhalt$="abc" und komment$="def".

   FUNCTION finf.get_var(such$,VAR result$)
      Sucht die Variable "such$" und weist ihren Wert dem String
      result$ zu. Rckgabe 0 => Nicht gefunden.

   PROCEDURE finf.set_var(vname$,wert$)
      ndert den Wert der Variable vname$ in wert$. Dabei wird zuerst
      versucht, eine existierende Variable zu berschreiben. Wenn +
      vname$ aber gar nicht erst gefunden wird, wird die neue Variable
      hinten an die Datei angehngt.

  PROCEDURE finf.clear_var(vname$)
      Lscht die Variable vname$ aus.

   FUNCTION finf.read_first(VAR var$,wert$)
      Liest die gesamten Variablen der Datei zeilenweise aus.
      Rckgabe 0 -> es gibt keine Variable.

   FUNCTION finf.read_next(VAR var$,wert$)
      Liest die nchste Zeile. Rckgabe 0 -> keine weiteren Variablen.

BEISPIELE
   flydemo

AUTOR
   Uwe Ohse, 1992


