#ifndef TCACHE__INCLUDED
#define TCACHE__INCLUDED
#include <tos.h>

#ifndef NULL
#define NULL_NOT_DEFINED
#define NULL ((void*)0)
#endif

/* bentigte Strukturen zur Parameterbergabe an TCache>=5.6 */

/* Parameterblock fr Funktion RBCache 815 */
typedef struct
{
	int aktiv;
	int led;
	int memory;
	int hash_bits;
	int max_secs_read;
	int max_secs_write;
	int max_prefetch;
	int delay_time;
	int full;
	int percent;
}
CACHEDATA;

/* Unterstruktur fr RBInformation */
/* Das ist der Teil, der auch geschrieben werden kann */
typedef struct
{
	int prefetch;
	char cache_aktiv;
	char mediach;
	int write_aktiv;
	int delayed_aktiv;
	int write_protect;
	int calculate;
	int fat;
}
DRIVEDATA;

/* Parameter fr Funktion RBInformation 816 */
typedef struct
{
	long reads;
	long read_hits;
	long writes;
	long write_hits;
	long errors;
	long odd;
	int recsize;
	DRIVEDATA data;
}
INFODATA;

/* Parameter fr RBHide 821 */
typedef struct
{
	long passwort;
	int drives[16];
}
HIDEDATA;

/* Parameter fr RBDrvA 822 */
typedef char DRVADATA[16];

/* Parameter fr RBRam 823 */
typedef struct
{
	int ram_drv;
	int ram_ok;
	BPB ram_bpb;
	int ram_mem;
	long *ram_ptr;
	BASPAG *base_page;
	char resetfest;
	char reserved;
}
RBRAMDATA;

/* Parameter fr RBDefRamDrv 836 */
typedef struct
{
	int ram_drv;
	int ram_size;
}
RBRAMDEFDATA;

/* Parameter fr RBAbortFehler 839 */
typedef struct
{
	int fehler_drv;
	long fehler_sec;
}
RBFEHLERLOC;

/* Parameter fr RBGetFehler 838 */
typedef struct
{
	int fehler_nummer;
	RBFEHLERLOC fehler_loc;
}
RBFEHLERDATA;

/* Parameter fr RBMore 841 */
typedef struct
{
	long abs_read;
	long abs_write;
	long write_error;
	long einzelsektor;
	long multisektor;
	long total;
	long saved;
	long reserved[10];
}
RBMOREDATA;

/* Cookie-Funktionen von TCache */
/* Tcache installiert? */
#define TCache_There (call_tcache!=NULL)

/* Zeiger auf Routinen */
long cdecl (*call_tcache)(int,...);

/* externes Modul, das die Register sichert */
extern long cdecl do_call_tcache(int,...);

/* jetzt folgen alle Cookie-Funktionsnummern */
#define RBCacheN		815
#define RBInformationN	816
#define RBSaveN			817
#define RBLockN			818
#define RBFlushN 		819
#define RBClrN			820
#define RBHideN			821
#define RBDrvAN			822
#define RBRamN			823
#define RBUhrN			824
#define RBGemdosN		825
#define RBAccN			826
#define RBMemN			827
#define RBCacheHitN		828
#define RBWriteN		828
#define RBFlush_etvN	829
#define RBStepN			830
#define RBVirtuellN		831
#define RBXBRAchecN		832
#define RBDrvbitcheckN	833
#define RBPun_InfoN		834
#define RBNoxN			835
#define RBDefRamDrvN	836
#define RBStopN			837
#define RBGetFehlerN	838
#define RBAbortFehlerN	839
#define RBAbsolutN		840
#define RBMoreN			841

#define RBTestingN 		997
#define RBInstalledN	998
#define RBFmediachN		999
/* jetzt fertige Cookie-Funktionsaufrufe */
#define RBCache(flag,dataptr)\
	((int(*)(int,int,CACHEDATA*))do_call_tcache)(RBCacheN,flag,dataptr)

#define RBInformation(drv,flag,data)\
	((void(*)(int,int,int,INFODATA*))do_call_tcache)(RBInformationN,drv,flag,data);

#define RBSave(name)\
	((void(*)(int,char *))do_call_tcache)(RBSaveN,name)

#define RBLock(status)\
	((int(*)(int,int))do_call_tcache)(RBLockN,status)

#define RBFlush()\
	((void(*)(int))do_call_tcache)(RBFlushN)

#define RBClr()\
	((void(*)(int))do_call_tcache)(RBClrN)

#define RBHide(flag,data)\
	((void(*)(int,int,HIDEDATA*))do_call_tcache)(RBHideN,flag,data)

#define RBDrvA(flag,data)\
	((void(*)(int,int,DRVADATA))do_call_tcache)(RBDrvAN,flag,data)

#define RBRam(flag,data)\
	((void(*)(int,int,RBRAMDATA*))do_call_tcache)(RBRamN,flag,data)

#define RBUhr(status)\
	((int(*)(int,int))do_call_tcache)(RBUhrN,status)

#define RBGemdos(status)\
	((int(*)(int,int))do_call_tcache)(RBGemdosN,status)

#define RBAcc(status,name)\
	((int(*)(int,int,char*))do_call_tcache)(RBAccN,status,name)

#define RBMem()\
	((long(*)(int))do_call_tcache)(RBMemN)

#define RBCacheHit(status)\
	((int(*)(int,int))do_call_tcache)(RBCacheHitN,status)

#define RBWrite(status)\
	((int(*)(int,int))do_call_tcache)(RBWriteN,status)

#define RBFlush_etv(status)\
	((int(*)(int,int))do_call_tcache)(RBFlush_etvN,status)

#define RBStep(status,stellen,raten)\
	((int(*)(int,int,int,int*))do_call_tcache)(RBStepN,status,stellen,raten)

#define RBVirtuell(virtmap)\
	((unsigned int (*)(int,long))do_call_tcache)(RBVirtuellN,virtmap)

#define RBXBracheck(status)\
	((int(*)(int,int))do_call_tcache)(RBXBRAchecN,status)

#define RBDrvbitcheck(status)\
	((int(*)(int,int))do_call_tcache)(RBDrvbitcheckN,status)

#define RBInstalled()\
	((int(*)(int))do_call_tcache)(RBInstalledN)

#define RBFmediach(drive)\
	((void(*)(int,int))do_call_tcache)(RBFmediachN,drive)

#define RBPun_Info(status)\
	((int(*)(int,int))do_call_tcache)(RBPun_InfoN,status)

#define RBNox(status)\
	((int(*)(int,int))do_call_tcache)(RBNoxN,status)

#define RBDefRamDrv(flag,data)\
	((void(*)(int,int,RBRAMDEFDATA*))do_call_tcache)\
				(RBDefRamDrvN,flag,data)

#define RBStop(flag)\
	((int(*)(int,int))do_call_tcache)(RBStopN,int)

#define RBGetFehler(data)\
	((void(*)(int,RBFEHLERDATA*))do_call_tcache)\
				(RBGetFehlerN,data)

#define RBAbortFehler(data)\
	((void(*)(int,RBFEHLERLOC*))do_call_tcache)\
				(RBAbortFehlerN,data)

#define RBAbsolut(flag)\
	((int(*)(int,int))do_call_tcache)(RBAbsolutN,flag)

#define RBMore(data)\
	((void(*)(int,RBMOREDATA*))do_call_tcache)(RBMoreN,data)

#define RBTesting(flag)\
	((int(*)(int))do_call_tcache)(RBTestingN,flag)


#ifdef NULL_NOT_DEFINED
#undef NULL
#undef NULL_NOT_DEFINED
#endif

#endif /* TCACHE__INCLUDED */
