/* XCONTROL.H - Includedateien zum XCONTROL */
/* s. ST-Computer 3/91 */


/* Definitionen */
#define	VERTIKAL		0
#define	HORIZTONTAL		1

#define	SAVE_DEFAULTS	0
#define	MEM_ERR			1
#define FILE_ERR		2
#define FILE_NOT_FOUND	3

#define MFSAVE			1
#define MFRESTORE		0

#define CT_KEY			53

/* Wenn eine Message von Xcontrol kommt */
#define MESSAGE -1


/* Header eines CPX-Moduls */
typedef struct
{
	UWORD		magic;				/* Muss 100 sein */

	struct
	{
		unsigned	reserved:	13;
		unsigned	resident:	1;	/* RAM-Resident */
		unsigned	bootinit:	1;	/* Boot-Initialisierung */
		unsigned	setonly:	1;	/* Set-Only */

	}flags;

	LONG		cpx_id;				/* CPX-ID */
	UWORD		cpx_version;		/* CPX-Versionsnummer */
	BYTE		i_text[14];			/* Icontext */
/*	UWORD		sm_icon[48];		/* Bitmap( 32 * 24 Pixel ) */*/
	ULONG		sm_icon[24];
	UWORD		i_color;			/* Iconfarbe */
	BYTE		title_text[18];		/* CPX-Name */
	UWORD		t_color;			/* Textfarbe */
	BYTE		buffer[64];			/* nicht flchtiger Puffer */
	BYTE		reserved[306];		/* reserviert */

}CPXHEAD;

/* Ergebnisstruktur fr Mausereignis */

typedef struct
{
	WORD		x, y;
	WORD		buttons;
	WORD		kstate;

}MRETS;

/* Definition der Funktionen zur Ereignisbehandlung */

typedef struct
{
	WORD		cdecl (* cpx_call ) ( GRECT *work );
	VOID		cdecl (* cpx_draw ) ( GRECT *clip );
	VOID		cdecl (* cpx_vmove ) ( GRECT *work );
	VOID		cdecl (* cpx_timer ) ( WORD *event );
	VOID		cdecl (* cpx_key ) ( WORD kstate, WORD key, WORD *event );
	VOID		cdecl (* cpx_button ) ( MRETS *mrets, WORD nclicks, WORD *event );
	VOID		cdecl (* cpx_m1 ) ( MRETS *mrets, WORD *event );
	VOID		cdecl (* cpx_m2 ) ( MRETS *mrets, WORD *event );
	WORD		cdecl (* cpx_hook ) ( WORD event, WORD *msg, MRETS *mrets, WORD *key, WORD *nclicks );
	VOID		cdecl (* cpx_close ) ( WORD flag );

}CPX_INFO;

/* Vom Kontrollfeld zur Verfgung gestellte Funktionen */
typedef struct
{
	WORD		handle;				/* aus graf_handle() */
	WORD		booting;
	WORD		reserved;
	WORD		SkipRshFix;			/* ungleich: RSC-Koordinaten schon gefixed */

	VOID		*reserve1;
	VOID		*reserve2;

	VOID		cdecl (* rsh_fix ) ( WORD num_objs, WORD num_frstr, WORD num_frimg, WORD num_tree, OBJECT *rs_object, TEDINFO *rs_tedinfo, BYTE *rs_strings[], ICONBLK *rs_iconblk, BITBLK *rs_bitblk, LONG *rs_frstr, LONG *rs_frimg, LONG *rs_trindex, \
									 struct foobar *rs_imdope );

	VOID		cdecl (* rsh_obfix ) ( OBJECT *tree, WORD curob );
	WORD		cdecl (* Popup ) ( BYTE *items, WORD num_items, WORD default_item, WORD font_size, GRECT *button, GRECT *world );
	VOID		cdecl (* Sl_size ) ( OBJECT *tree, WORD base, WORD slider, WORD num_items, WORD visible, WORD direction, WORD min_size );
	VOID		cdecl (* Sl_x ) ( OBJECT *tree, WORD base, WORD slider, WORD value, WORD num_min, WORD num_max, VOID (* foo ) ( VOID ) );
	VOID		cdecl (* Sl_y ) ( OBJECT *tree, WORD base, WORD slider, WORD value, WORD num_min, WORD num_max, VOID (* foo ) ( VOID ) );
	VOID		cdecl (* Sl_arrow ) ( OBJECT *tree, WORD base, WORD slider, WORD obj, WORD inc, WORD min, WORD max, WORD *numvar, WORD drrection, VOID (* foo ) ( VOID ) );
	VOID		cdecl (* Sl_drawx ) ( OBJECT *tree, WORD base, WORD slider, WORD min, WORD max, WORD numvar, VOID (* foo ) ( VOID ) );
	VOID		cdecl (* Sl_drawy ) ( OBJECT *tree, WORD base, WORD slider, WORD min, WORD max, WORD numvar, VOID (* foo ) ( VOID ) );
	WORD		cdecl (* Xform_do ) ( OBJECT *tree, WORD start_field, WORD *puntmsg );
	GRECT*		cdecl (* GetFirstRect ) ( GRECT *prect );
	GRECT*		cdecl (* GetNextRect ) ( VOID );
	VOID		cdecl (* Set_Evnt_Mask ) ( WORD mask, MOBLK *m1, MOBLK *m2, LONG time );
	WORD		cdecl (* XGen_alert ) ( WORD id );
	WORD		cdecl (* CPX_Save ) ( VOID *ptr, LONG num );
	VOID*		cdecl (* Get_Buffer ) ( VOID );
	WORD		cdecl (* getcokie ) ( LONG cookie, LONG *p_value );
	WORD		Country_Code;		/* Lnderkennung */
	VOID		cdecl (* MFsave ) ( WORD saveit, MFORM *mf );

}XCPB;
